/*******************************************************************
/*  GroupUnit.h
/*  Author: Vadim Berman
/*
/*  Description:
/*  declaration of Group class. Group is an Agent managing other Agents,
/*  which is able to use squad tactics
/*
/*  The contents of this file are subject to the Brainiac Public License.
/*  Version 1.0 (the "License"); you may not use this file except in
/*  compliance with the License. You may obtain a copy of the License at
/*  http://www.twilightminds.com
/*
/*  Software distributed under the License is distributed on an "AS IS"
/*  basis WITHOUT WARRANTY OF ANY KIND, either express or implied. See
/*  the License for the specific language governing rights and limitations
/*  under the License.
/*
/*  Copyright (C) 1999 Twilight Minds. All rights reserved.
/********************************************************************/
//---------------------------------------------------------------------------
#ifndef GroupUnitH
#define GroupUnitH
//---------------------------------------------------------------------------
#include "AlignmentUnit.h"
//---------------------------------------------------------------------------
class EXPO Group:public Agent{
public:
    BBECALL Group();
    BBECALL ~Group();
    ActionError BBECALL ExecuteNextAction(void *, Agent** = NULL,
        unsigned short = 0,
        ItemPtrArr* = NULL, unsigned short * = 0);
    ActionError BBECALL ExecuteCommonEffort(void *, Agent** = NULL,
        unsigned short = 0,
        ItemPtrArr* = NULL, unsigned short * = 0);
    ActionError BBECALL ExecuteMemberSelection(void *, Agent** = NULL,
        unsigned short = 0,
        ItemPtrArr* = NULL, unsigned short * = 0);
    ActionError BBECALL ExecuteDifferentActions(void *, Agent** = NULL,
        unsigned short = 0,
        ItemPtrArr* = NULL, unsigned short * = 0);
    int BBECALL AddMember(Agent*,int = -1);
    void BBECALL RemoveMember(unsigned short);
    void BBECALL SetLeader(unsigned short);
    unsigned short BBECALL GetLeaderIndex();
    void BBECALL Dismantle();
    void BBECALL DisposeStrategies();
    int  BBECALL FindCriterionMatch(ID);
    BOOL BBECALL PickStrategy(Goal , Core *,ItemScores * = NULL);
    BOOL BBECALL AssignInitiatorsInGroupStrategy(Strategy *);
    void BBECALL SetActionsOrder(int*,int = 0);
    BOOL BBECALL AssignGroupStrategy();
    unsigned char BBECALL ActivityMode();
    void BBECALL SetActivityMode(unsigned char);
    //attention: Agent is scanned here instead of Core
    BOOL BBECALL Scan(Agent *,ItemPtrArr ,
		unsigned short , ID , void * );
    void BBECALL CalcCore();
    unsigned char LeadershipType,ExecType;
    ID BBECALL GetMemberCriterion();
    unsigned short BBECALL GetMembersQty();
    Core *BBECALL GetMemberCoreAddress(unsigned short);
    Agent *BBECALL GetLeader();
    Agent *BBECALL GetMember(unsigned short);
    void BBECALL SetMemberCriterion(ID );
    void BBECALL SetNewMemberChkFn(int (BBECALL *)(void*));
    unsigned short MaxMembersQty;
    Core *BBECALL GetLeaderCoreAddress();
    percentage BBECALL CalcNeutralSideMeanness(Agent **,
        unsigned short , Action *);
    BOOL BBECALL IsGroupMember(ID );
    BOOL BBECALL AssignStrategy(ID ,unsigned short, BOOL = FALSE );
    /*serves as NEEDED members quantity in
    groups created for strategy completion*/
protected:
    unsigned short LeaderIndex,MembersQty;
    unsigned char Activity;
    /*Note: each strategy pointer must be coordinated with
        Members array members (that is, the same index)*/
    Agent **Members;
    Strategy **StrParts; /*These strategies are parts of the common
                        "squad strategy"*/
    ID MemberCriterion; //only for Groups not targetted at one goal
    int (BBECALL *NewMemberChkFn)(void*);
        /*User-defined function
        used to handle a new member addition (queries, etc.)*/
};

//---------------------------------------------------------------------------
EXPO Group *BBECALL CreateGroup(Agent *,ID,Core * = NULL,ItemScores * = NULL);
void EXPO BBECALL SetDefaultMemberCheckFn(int (BBECALL *)(void*));
//---------------------------------------------------------------------------
#endif
